/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.GraphPollingObjectDefinition;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GraphDefinition
implements Serializable {
    public static final int GRAPH_RANGE_ALL = 0;
    public static final int GRAPH_RANGE_MINUTES = 1;
    public static final int GRAPH_RANGE_HOURS = 2;
    public static final int GRAPH_RANGE_DAYS = 3;
    public static final int GRAPH_RANGE_WEEKS = 4;
    public static final int GRAPH_RANGE_MONTHS = 5;
    public static final int GRAPH_RANGE_YEARS = 6;
    public static final int GRAPH_RANGE_POINTS = 7;
    public static final int GRAPH_FIRST_RANGE = 0;
    public static final int GRAPH_LAST_RANGE = 7;
    public static final int PERIOD_ENDING_NOW = 0;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    public static final long MILLIS_IN_YEAR = 31449600000L;
    public static final int MAX_SERIES_SHOWN = 10;
    public static final int GRAPH_TYPE_PLOT = 0;
    public static final int GRAPH_TYPE_BAR = 9;
    public static final int GRAPH_TYPE_STACKED_BAR = 10;
    public static final int GRAPH_TYPE_PIE = 11;
    public static final int GRAPH_TYPE_100_PERCENT = -1;
    private String graphName;
    private int graphType;
    private long graphRangeNumber;
    private int graphRangeUnits = 0;
    private long periodEndingNumber;
    private int periodEndingUnits = 0;
    private Hashtable pollingObjects;
    private String units;

    public GraphDefinition(String string) {
        this.graphName = string;
        this.pollingObjects = new Hashtable();
    }

    public void addPollingObject(GraphPollingObjectDefinition graphPollingObjectDefinition) {
        this.pollingObjects.put(graphPollingObjectDefinition.getIdentifier(), graphPollingObjectDefinition);
    }

    public Vector getPollingIdentifiers() {
        Vector vector = new Vector();
        Enumeration enumeration = this.pollingObjects.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public void setGraphType(int n) {
        this.graphType = n;
    }

    public void setGraphRange(long l, int n) {
        if (n >= 0 && n <= 7) {
            this.graphRangeUnits = n;
            this.graphRangeNumber = l;
        }
    }

    public void setPeriodEnding(long l, int n) {
        if (n >= 0 && n <= 7) {
            this.periodEndingUnits = n;
            this.periodEndingNumber = l;
        }
    }

    public long getGraphRangeMillis() {
        long l = 0L;
        switch (this.graphRangeUnits) {
            case 1: {
                l = this.graphRangeNumber * 60000L;
                break;
            }
            case 2: {
                l = this.graphRangeNumber * 3600000L;
                break;
            }
            case 3: {
                l = this.graphRangeNumber * 86400000L;
                break;
            }
            case 4: {
                l = this.graphRangeNumber * 604800000L;
                break;
            }
            case 6: {
                l = this.graphRangeNumber * 31449600000L;
                break;
            }
        }
        return l;
    }

    public long getPeriodEndingMillis() {
        long l = 0L;
        switch (this.periodEndingUnits) {
            case 1: {
                l = this.periodEndingNumber * 60000L;
                break;
            }
            case 2: {
                l = this.periodEndingNumber * 3600000L;
                break;
            }
            case 3: {
                l = this.periodEndingNumber * 86400000L;
                break;
            }
            case 4: {
                l = this.periodEndingNumber * 604800000L;
                break;
            }
            case 6: {
                l = this.periodEndingNumber * 31449600000L;
                break;
            }
        }
        return l;
    }

    public int getGraphType() {
        return this.graphType;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public long getGraphRangeNumber() {
        return this.graphRangeNumber;
    }

    public int getGraphRangeUnits() {
        return this.graphRangeUnits;
    }

    public int getPeriodEndingUnits() {
        return this.periodEndingUnits;
    }

    public String getUnits() {
        return this.units;
    }

    public Hashtable getPollingObjects() {
        return this.pollingObjects;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        GraphDefinition graphDefinition = (GraphDefinition)object;
        if (graphDefinition.getGraphName().equals(this.graphName)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Graph Definition:");
        stringBuffer.append("\n Graph Type = " + this.graphType);
        stringBuffer.append("\n Polling Objects = " + this.pollingObjects);
        return stringBuffer.toString();
    }
}

